
#import "CalObject.h"
#include <stdio.h>
#include <time.h>
#include <sys/types.h>

@implementation CalObject

	NXRect frame;
 	int temp_x, temp_y;

// LoginStats by Eric "E.T." Tremblay, January 29, 1996

//INIT
// This is one of the first methods executed. (Presently not used)
// after the nib is loaded. This is not the best way to initialize
// an object because not all method and varibles are ready to be used.
- init
{	
	[super init];
		
        return self;
}


// AWAKEFROMNIB
// This is one of the last methods executed after the nib file is loaded.
// This is the BEST way I know how to initialize an object and jump into
// a method after the nib file was loaded, because you are all the methods
// and variables needed can be used. (Unlike init which is not compeletly
// ready when that message is sent
- awakeFromNib
{
 
	[self SetDate:NULL];
	[self Last:NULL];

    	return self;
}





// LoginAccounting
// Executes the /usr/etc/ac to produces a printout giving connect time for each // user who has logged in during the life of the current wtmp file.
- LoginAccounting:sender
{    	

	// Local Variables
	FILE *calCmd;
	char c, buff[100000], *pbuff;
	
	[LoginStatsPanel makeKeyAndOrderFront:NULL];

	sprintf( buff, "/usr/etc/ac -p");
	if ( (calCmd=popen(buff, "r")) == NULL )
        [[LoginStatsView docView] setText:"Can't build the Scrollview!"];
	else {
		pbuff = buff;
		while( (c=fgetc(calCmd)) != EOF )
			*(pbuff++)=c;
		*pbuff='\0';
		pclose(calCmd);
		[[LoginStatsView docView] setText:buff];
		}
    
 	[LoginStatsView display];

        return self;
}



// Last
- Last:sender
{
	// Local Variables
	FILE *calCmd;
	char c, buff[100000], *pbuff;
	
	[LoginStatsPanel makeKeyAndOrderFront:NULL];

	sprintf( buff, "last");
	if ( (calCmd=popen(buff, "r")) == NULL )
        [[LoginStatsView docView] setText:"Can't build the Scrollview!"];
	else {
		pbuff = buff;
		while( (c=fgetc(calCmd)) != EOF )
			*(pbuff++)=c;
		*pbuff='\0';
		pclose(calCmd);
		[[LoginStatsView docView] setText:buff];
		}
    
 	[LoginStatsView display];

	return self;
}

// SearchLast
// This method builds the proper calendar in the window
- SearchLast:sender
{
	// Local Variables
	FILE *calCmd;
	char c, buff[100000], *pbuff;
	char *username;
        char *datestring;

	
	[LoginStatsPanel makeKeyAndOrderFront:NULL];

        username = [UsernameInput stringValue];
        datestring = [DateInput stringValue];

	//sprintf( buff, "last | grep eric | grep 'Dec 29'"); 

	sprintf( buff,"last | grep %s | grep '%s'",username,datestring);

	if ( (calCmd=popen(buff, "r")) == NULL )
        [[LoginStatsView docView] setText:"Can't build calendar!"];
	else {
		pbuff = buff;
		while( (c=fgetc(calCmd)) != EOF )
			*(pbuff++)=c;
		*pbuff='\0';
		pclose(calCmd);
		[[LoginStatsView docView] setText:buff];
		}
    
 	[LoginStatsView display];

	return self;
}

// SET DATE
- SetDate:sender
// This will assign variables for the current date.
{
    
	// Local Variables
        char *MonthString;
	char buff[500];

	long time(), tmpTime;
	struct tm *tm, *localtime();
	tmpTime = time(0);
	tm = localtime( &tmpTime );
        day = (tm->tm_mday);
	month = (tm->tm_mon+1);


  switch (month)  { /* start switch */
   
   case 1:
          MonthString = "Jan";
	  break;
	  
   case 2:
          MonthString = "Feb";
          break;
	  
   case 3:
          MonthString = "Mar";
	    break;

   case 4:
          MonthString = "Apr";
	    break;

   case 5:
          MonthString = "May";
	    break;

   case 6:
          MonthString = "Jun";
	    break;

   case 7:
          MonthString = "Jul";
	    break;

   case 8:
          MonthString = "Aug";
	    break;

   case 9:
          MonthString = "Sep";
	    break;

   case 10:
          MonthString = "Oct";
	    break;

   case 11:
          MonthString = "Nov";
	    break;
 
   case 12:
          MonthString = "Dec";
	    break;
	                        } /* end switch */

	sprintf( buff,"%s %d",MonthString,day);
        [DateInput setStringValue:buff];



    return self;
 }


// PRINT
- Print:sender
// This method will print the LoginStatsView to the printer
// Printing is rather simple; just send printPSCode: to the text view
// you wish to print. The print panel will automatically pop up and unless
// the user cancels the printout the text view will be printed.
{
    
    [[LoginStatsView docView] printPSCode:self];
    return self;
 }


@end
